<?php 
/*
	TITLE       : CLASS Upload
	FILE        : class.upload.php
	DESCRIPTION : To provide upload utility,
	AUTHOR      : Peng Zhang zpadmin()gmail.com http://blog.neten.de
	BASED ON    : whxbb whxbb()21cn.com
	WRITED      : 2005 NOV 20
	MODIFIED    : 2006 MAR 01
	modify by psdshow (psdshow(at)yahoo.com.cn) 2007-10-16
	LICENCE     : GPL
	REVISION    : V1.0.2
*/
class Upload{
	var $saveName;// 
	var $savePath;// ·
	var $fileFormat = array('gif','jpg','doc','application/octet-stream');// ļʽ&MIME޶
	var $overwrite = 0;// ģʽ
	var $maxSize = 0;// ļֽ
	var $ext;// ļչ
	var $thumb = 0;// Ƿͼ
	var $thumbWidth = 130;// ͼ
	var $thumbHeight = 130;// ͼ
	var $thumbPrefix = "_thumb_";// ͼǰ׺
	var $errno;// 
	var $returnArray= array();// ļķϢ
	var $returninfo= array();// ÿļϢ


// 캯
// @param $savePath ļ·
// @param $fileFormat ļʽ
// @param $maxSize ļߴ
// @param $overwriet Ƿ񸲸 1  0 ֹ

	function Upload($savePath, $fileFormat='',$maxSize = 0, $overwrite = 0) {
		$this->setSavepath($savePath);
		$this->setFileformat($fileFormat);
		$this->setMaxsize($maxSize);
		$this->setOverwrite($overwrite);
		$this->setThumb($this->thumb, $this->thumbWidth,$this->thumbHeight);
		$this->errno = 0;
	}

// ϴ
// @param $fileInput ҳForm()input
// @param $changeName Ƿļ
	function run($fileInput,$changeName = 1){
		if(isset($_FILES[$fileInput])){
			$fileArr = $_FILES[$fileInput];
			if(is_array($fileArr['name'])){//ϴͬļƶļ
				for($i = 0; $i < count($fileArr['name']); $i++){
					$ar['tmp_name'] = $fileArr['tmp_name'][$i];
					$ar['name'] = $fileArr['name'][$i];
					$ar['type'] = $fileArr['type'][$i];
					$ar['size'] = $fileArr['size'][$i];
					$ar['error'] = $fileArr['error'][$i];
					$this->getExt($ar['name']);//ȡչ$this->ext´ѭ
					$this->setSavename($changeName == 1 ? '' : $ar['name']);//ñļ
					if($this->copyfile($ar)){
						$this->returnArray[] =  $this->returninfo;
					}else{
						$this->returninfo['error'] = $this->errmsg();
						$this->returnArray[] =  $this->returninfo;
					}
				}
				return $this->errno ?  false :  true;
			}else{//ϴļ
				$this->getExt($fileArr['name']);//ȡչ
				$this->setSavename($changeName == 1 ? '' : $fileArr['name']);//ñļ
				if($this->copyfile($fileArr)){
					$this->returnArray[] =  $this->returninfo;
				}else{
					$this->returninfo['error'] = $this->errmsg();
					$this->returnArray[] =  $this->returninfo;
				}
				return $this->errno ?  false :  true;
			}
			return false;
		}else{
			$this->errno = 10;
			return false;
		}
	}

// ļϴ
// @param $fileArray ļϢ
	function copyfile($fileArray){
		$this->returninfo = array();
		// Ϣ
		$this->returninfo['name'] = $fileArray['name'];
		$this->returninfo['saveName'] = $this->saveName;
		$this->returninfo['size'] = number_format( ($fileArray['size'])/1024 , 0, '.', ' ');//KBΪλ
		$this->returninfo['type'] = $fileArray['type'];
		// ļʽ
		if (!$this->validateFormat()){
			$this->errno = 11;
			return false;
		}
		// Ŀ¼Ƿд
		if(!@is_writable($this->savePath)){
			$this->errno = 12;
			return false;
		}
		// ǣļǷѾ
		if($this->overwrite == 0 && @file_exists($this->savePath.$fileArray['name'])){
			$this->errno = 13;
			return false;
		}
		// дСƣļǷ񳬹
		if ($this->maxSize != 0 ){
			if ($fileArray["size"] > $this->maxSize){
				$this->errno = 14;
				return false;
			}
		}
		// ļϴ
		if(!@move_uploaded_file($fileArray["tmp_name"], $this->savePath.$this->saveName)){
			$this->errno = $fileArray["error"];
			return false;
		}elseif( $this->thumb ){// ͼ
			$CreateFunction = "imagecreatefrom".($this->ext == 'jpg' ? 'jpeg' : $this->ext);
			$SaveFunction = "image".($this->ext == 'jpg' ? 'jpeg' : $this->ext);
			if (strtolower($CreateFunction) == "imagecreatefromgif" 
				&& !function_exists("imagecreatefromgif")) {
				$this->errno = 16;
				return false;
			} elseif (strtolower($CreateFunction) == "imagecreatefromjpeg" 
				&& !function_exists("imagecreatefromjpeg")) {
				$this->errno = 17;
				return false;
			} elseif (!function_exists($CreateFunction)) {
				$this->errno = 18;
				return false;
			}
				
			$Original = @$CreateFunction($this->savePath.$this->saveName);
			if (!$Original) {$this->errno = 19; return false;}
			$originalHeight = ImageSY($Original);
			$originalWidth = ImageSX($Original);
			$this->returninfo['originalHeight'] = $originalHeight;
			$this->returninfo['originalWidth'] = $originalWidth;
			if (($originalHeight < $this->thumbHeight 
				&& $originalWidth < $this->thumbWidth)) {
				// ͼСֻCopy
				move_uploaded_file($this->savePath.$this->saveName, 
					$this->savePath.$this->thumbPrefix.$this->saveName);
			} else {
				if( $originalWidth > $this->thumbWidth ){//  > 趨
					$thumbWidth = $this->thumbWidth ;
					$thumbHeight = $this->thumbWidth * ( $originalHeight / $originalWidth );
					if($thumbHeight > $this->thumbHeight){//  > 趨߶
						$thumbWidth = $this->thumbHeight * ( $thumbWidth / $thumbHeight );
						$thumbHeight = $this->thumbHeight ;
					}
				}elseif( $originalHeight > $this->thumbHeight ){//  > 趨߶
					$thumbHeight = $this->thumbHeight ;
					$thumbWidth = $this->thumbHeight * ( $originalWidth / $originalHeight );
					if($thumbWidth > $this->thumbWidth){//  > 趨
						$thumbHeight = $this->thumbWidth * ( $thumbHeight / $thumbWidth );
						$thumbWidth = $this->thumbWidth ;
					}
				}
				if ($thumbWidth == 0) $thumbWidth = 1;
				if ($thumbHeight == 0) $thumbHeight = 1;
				$createdThumb = imagecreatetruecolor($thumbWidth, $thumbHeight);
				if ( !$createdThumb ) {$this->errno = 20; return false;}
				if ( !imagecopyresampled($createdThumb, $Original, 0, 0, 0, 0, 
					$thumbWidth, $thumbHeight, $originalWidth, $originalHeight) )
					{$this->errno = 21; return false;}
				if ( !$SaveFunction($createdThumb, 
					$this->savePath.$this->thumbPrefix.$this->saveName) )
					{$this->errno = 22; return false;}
			}
		}
		// ɾʱļ
		/*
		if(!@$this->del($fileArray["tmp_name"])){
			return false;
		}
		*/
		return true;
	}

// ļʽ,MIME
	function validateFormat(){
		if(!is_array($this->fileFormat) 
			|| in_array(strtolower($this->ext), $this->fileFormat) 
			|| in_array(strtolower($this->returninfo['type']), $this->fileFormat) )
			return true;
		else
			return false;
	}
// ȡļչ
// @param $fileName ϴļԭļ
	function getExt($fileName){
		$ext = explode(".", $fileName);
		$ext = $ext[count($ext) - 1];
		$this->ext = strtolower($ext);
	}

// ϴļֽ
// @param $maxSize ļС(bytes) 0:ʾ
	function setMaxsize($maxSize){
		$this->maxSize = $maxSize;
	}
// ļʽ޶
// @param $fileFormat ļʽ
	function setFileformat($fileFormat){
		if(is_array($fileFormat)){$this->fileFormat = $fileFormat ;}
	}

// øģʽ
// @param overwrite ģʽ 1: 0:ֹ
	function setOverwrite($overwrite){
		$this->overwrite = $overwrite;
	}


// ñ·
// @param $savePath ļ· "/" βû "/"
	function setSavepath($savePath){
		$this->savePath = substr( str_replace("\\","/", $savePath) , -1) == "/" 
		? $savePath : $savePath."/";
	}

// ͼ
// @param $thumb = 1 ͼ $thumbWidth,$thumbHeight ͼĿ͸
	function setThumb($thumb, $thumbWidth = 0,$thumbHeight = 0){
		$this->thumb = $thumb;
		if($thumbWidth) $this->thumbWidth = $thumbWidth;
		if($thumbHeight) $this->thumbHeight = $thumbHeight;
	}

// ļ
// @param $saveName ΪգϵͳԶһļ
	function setSavename($saveName){
		if ($saveName == ''){  // δļһļ
			$name = date('YmdHis')."_".rand(100,999).'.'.$this->ext;
			//жļǷ,ظļ
			if(file_exists($this->savePath . $name)){
				$name = setSavename($saveName);
				}
		} else {
			$name = $saveName;
		}
		$this->saveName = $name;
	}

// ɾļ
// @param $fileName Ҫɾļ
	function del($fileName){
		if(!@unlink($fileName)){
			$this->errno = 15;
			return false;
		}
		return true;
	}

// ϴļϢ
	function getInfo(){
		return $this->returnArray;
	}

// õϢ
	function errmsg(){
		$uploadClassError = array(
			0	=>'There is no error, the file uploaded with success. ',
			1	=>'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
			2	=>'The uploaded file exceeds the MAX_FILE_SIZE that was specified in the HTML form.',
			3	=>'The uploaded file was only partially uploaded. ',
			4	=>'No file was uploaded. ',
			6	=>'Missing a temporary folder. Introduced in PHP 4.3.10 and PHP 5.0.3. ',
			7	=>'Failed to write file to disk. Introduced in PHP 5.1.0. ',
			10	=>'Input name is not unavailable!',
			11	=>'The uploaded file is Unallowable!',
			12	=>'Directory unwritable!',
			13	=>'File exist already!',
			14	=>'File is too big!',
			15	=>'Delete file unsuccessfully!',
			16	=>'Your version of PHP does not appear to have GIF thumbnailing support.',
			17	=>'Your version of PHP does not appear to have JPEG thumbnailing support.',
			18	=>'Your version of PHP does not appear to have pictures thumbnailing support.',
			19	=>'An error occurred while attempting to copy the source image . 
					Your version of php ('.phpversion().') may not have this image type support.',
			20	=>'An error occurred while attempting to create a new image.',
			21	=>'An error occurred while copying the source image to the thumbnail image.',
			22	=>'An error occurred while saving the thumbnail image to the filesystem. 
					Are you sure that PHP has been configured with both read and write access on this folder?',
			);
		if ($this->errno == 0)
			return false;
		else
			return $uploadClassError[$this->errno];
	}
}
?>